//	Maze4DGPUDefinitions.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

#ifndef Maze4DGPUDefinitions_h
#define Maze4DGPUDefinitions_h

#include <simd/simd.h>

enum
{
	VertexAttributePosition	= 0,
	VertexAttributeNormal	= 1,
	VertexAttributeWeight	= 2
};

enum
{
	BufferIndexVertexAttributes	= 0,
	BufferIndexUniforms			= 1,
	BufferIndexInstanceData		= 2
};

typedef struct
{
	simd_float4x4	itsModelMatrix;
	simd_half3		itsRGB;		//	(red, green, blue) for a single color
} Maze4DInstanceDataRGB;

typedef struct
{
	simd_float4x4	itsModelMatrix;
	simd_half2		itsHues;	//	(hue A, hue B) for two colors to be interpolated
} Maze4DInstanceDataHues;

typedef struct
{
	simd_float4x4			itsViewProjectionMatrix;

	simd_half4				itsFogEvaluator;		//	assumes model matrix already applied
	
	simd_half3				itsDiffuseEvaluator,	//	assumes model matrix already applied
							itsSpecularEvaluator;	//	assumes model matrix already applied

	Maze4DInstanceDataRGB	itsSliderInstanceData,
							itsGoalInstanceData,
							itsBoxInstanceData;

} Maze4DUniformData;

#endif /* Maze4DGPUDefinitions_h */
